#ifndef MembranePolarizationFluidSteppable_H
#define MembranePolarizationFluidSteppable_H

#include <CompuCell3D/Plugin.h>

#include <CompuCell3D/Potts3D/Cell.h>
#include <CompuCell3D/Steppable.h>
#include <CompuCell3D/Field3D/Dim3D.h>
#include <set>


#include <CompuCell3D/Potts3D/Potts3D.h>
#include <BasicUtils/BasicClassAccessor.h>
#include <BasicUtils/BasicRandomNumberGenerator.h>



#include <CompuCell3D/plugins/PixelTracker/PixelTrackerPlugin.h>
#include <CompuCell3D/plugins/PixelTracker/BoundaryPixelTrackerPlugin.h>
#include <CompuCell3D/plugins/PixelTracker/BoundaryPixelTracker.h>
#include <CompuCell3D/Boundary/BoundaryStrategy.h>
#include "../ClusterDataTrackerPlugin/ClusterDataTrackerPlugin.h"
#include "ClusterData.h"


template <typename Y> class BasicClassAccessor;
namespace CompuCell3D {
  
  
  template <class T> class Field3D;
  template <class T> class WatchableField3D;
	class Automaton;
    class Potts3D;
    class CellInventory;
    class CellG;

    class ClusterData;
    class PixelTrackerPlugin;
    class PixelTrackerData;
    class BoundaryStrategy;
    class BoundaryPixelTrackerPlugin;
    class ClusterDataTrackerPlugin;


  class MembranePolarizationFluidSteppable : public Steppable {

    BasicRandomNumberGenerator * rand; 
    CellInventory *cellInventoryPtr;
    WatchableField3D<CellG *> *fieldG;
    Simulator * sim;
    Potts3D *potts;
    Automaton *automaton;
    BoundaryStrategy *boundaryStrategy;
   

  public:
  
    double vesicleTargetVolume;
    double vesicleLambdaVolume;
    unsigned int maxNeighborIndex;
    unsigned int maxVesicleNeighborIndex;

    //conversion probabilities
    double pBtoV;
    double pAtoV;
    double pCtoA;
    double pCtoB;
    double pAtoA;
    double pBtoB;
    double pAtoB;
    double pBtoA;
    double pVtoA;
    double pVtoB;
    double pAtoC;
    double pBtoC;
    double pVtoC;
    double initializingStep;
     
    typedef struct{
      int membranePixelCount;
      int polarizedCount;
      int toBasolCount;
      std::set<PixelTrackerData> membranePixelSet;
      std::set<PixelTrackerData> insidePixelSet;
      std::set<PixelTrackerData> pixelsToBasolType;
      bool polarization;
       
    } membraneData;

    

//functions declaration

    std::map< long,std::set<CellG*> > makeClusterMap();
    void vesicleSecretion(long int ownClusterId);
    membraneData pixelsInMembrane(long int ownClusterId, bool listVesicleCandidates);
    membraneData pixelsInMembraneFast(long int ownClusterId, bool listVesicleCandidates);
    membraneData MPbyBM(long int ownClusterId, membraneData cellMembraneData);
    set<PixelTrackerData> pixelsToBasolTypeList(membraneData cellMembraneData, long clusterId);
    void vesicleCreation(long int ownClusterId, membraneData cellMembraneData);
    bool twoBasolNeigh(Point3D pt, long clusterId);
    bool probabilityPolarization(membraneData cellMembraneData, CellG *fromCell ,char toType );
    void MPlateral(long int ownClusterId, membraneData cellMembraneData);
    void depolarization(long int ownClusterId, membraneData cellMembraneData); 

    // Accessors for other plugins

	BasicClassAccessor <BoundaryPixelTracker> *bptAccessorPtr;
	BoundaryPixelTrackerPlugin *boundaryPixelTrackerPlugin;

	BasicClassAccessor <PixelTracker> *pixelTrackerAccessorPtr;
	PixelTrackerPlugin *pixelTrackerPlugin;
        
        BasicClassAccessor <ClusterDataTrackerPlugin> *clusterDataTrackerAccessorPtr;
	ClusterDataTrackerPlugin *clusterDataTrackerPlugin;

	BasicClassAccessor <ClusterData> 
	clusterDataAccessor;

    MembranePolarizationFluidSteppable();
    virtual ~MembranePolarizationFluidSteppable();
    // SimObject interface
    virtual void init(Simulator *simulator, CC3DXMLElement *_xmlData=0);
    virtual void extraInit(Simulator *simulator);


    virtual void start();
    virtual void step(const unsigned int currentStep);
    virtual void finish() {}



    //SteerableObject interface
    virtual void update(CC3DXMLElement *_xmlData, bool _fullInitFlag=false);
    virtual std::string steerableName();
	virtual std::string toString();


  };
};
#endif
